SET STATISTICS TIME ON
SET STATISTICS IO ON

-- Agregovan statistiky timesheet po pracovncch
SELECT
	PracovnikID,
	(SELECT COUNT(*) FROM TimesheetItem ti
		WHERE SchvalenoKdy IS NOT NULL
			AND ti.PracovnikID = Pracovnik.PracovnikID
	) AS PocetSchvalenychZaznamu,
	(SELECT COUNT(*) FROM TimesheetItem ti
		WHERE SchvalenoKdy IS NULL
			AND ti.PracovnikID = Pracovnik.PracovnikID
	) AS PocetNeschvalenychZaznamu,
	(SELECT SUM(PocetHodin) FROM TimesheetItem ti
		WHERE SchvalenoKdy IS NOT NULL
			AND ti.PracovnikID = Pracovnik.PracovnikID
	) AS PocetSchvalenychHodin,
	(SELECT SUM(PocetHodin) FROM TimesheetItem ti
		WHERE SchvalenoKdy IS NULL
			AND ti.PracovnikID = Pracovnik.PracovnikID
	) AS PocetNeschvalenychHodin,
	(SELECT SUM(OsobniNaklady) FROM TimesheetItem ti
		WHERE ti.PracovnikID = Pracovnik.PracovnikID
	) AS OsobniNakladyCelkem
	FROM Pracovnik
	ORDER BY PracovnikID
	
	
-- Jin zpis - jeden prchod
SELECT
	PracovnikID,
	SUM(CASE WHEN SchvalenoKdy IS NOT NULL THEN 1 ELSE 0 END)
		AS PocetSchvalenychZaznamu,
	SUM(CASE WHEN SchvalenoKdy IS NULL THEN 1 ELSE 0 END)
		AS PocetNeschvalenychZaznamu,
	SUM(CASE WHEN SchvalenoKdy IS NOT NULL THEN PocetHodin ELSE 0 END)
		AS PocetSchvalenychHodin,
	SUM(CASE WHEN SchvalenoKdy IS NULL THEN PocetHodin ELSE 0 END)
		AS PocetNeschvalenychHodin,
	SUM(OsobniNaklady) AS OsobniNakladyCelkem
	FROM TimesheetItem
	GROUP BY PracovnikID
	ORDER BY PracovnikID
